
///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//                           Double Integer - test                           //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////
// Compile as Release x64 !

#include "..\include.h"

// --- double integer uint128, sint128

// uint32, sint32 (only for test)
#define DBLUINT uint32	// double integer class unsigned
#define BASEUINT u16	// base integer unsigned
#define HALFUINT u8		// half integer unsigned
#define DBLSINT sint32	// double integer class signed
#define BASESINT s16	// base integer signed
#define HALFSINT s8		// half integer signed
#define DBLFIX fix32	// double fixed point class
#include "dblint_cpp.h"

// uint64, sint64 (only for test)
#define DBLUINT uint64	// double integer class unsigned
#define BASEUINT u32	// base integer unsigned
#define HALFUINT u16	// half integer unsigned
#define DBLSINT sint64	// double integer class signed
#define BASESINT s32	// base integer signed
#define HALFSINT s16	// half integer signed
#define DBLFIX fix64	// double fixed point class
#include "dblint_cpp.h"

// uint128, sint128 (with assembler)
#define DBLUINT uint128	// double integer class unsigned
#define BASEUINT u64	// base integer unsigned
#define HALFUINT u32	// half integer unsigned
#define DBLSINT sint128	// double integer class signed
#define BASESINT s64	// base integer signed
#define HALFSINT s32	// half integer signed
#define DBLFIX fix128	// double fixed point class
#define USEASM			// can use assembler
#include "dblint_cpp.h"

// uint128ref, sint128ref (without assembler - only for test as reference)
#define DBLUINT uint128ref // double integer class unsigned
#define BASEUINT u64	// base integer unsigned
#define HALFUINT u32	// half integer unsigned
#define DBLSINT sint128ref	// double integer class signed
#define BASESINT s64	// base integer signed
#define HALFSINT s32	// half integer signed
#define DBLFIX fix128ref // double fixed point class
#include "dblint_cpp.h"

// --- quadruple integer uint256, sint256

// uint64B, sint64B (only for test)
#define QUADUINT uint64B // quadruple integer class
#define DBLUINT uint32	// double integer class unsigned
#define BASEUINT u16	// base integer unsigned
#define HALFUINT u8		// half integer unsigned
#define QUADSINT sint64B // double integer class signed
#define DBLSINT sint32	// double integer class signed
#define BASESINT s16	// base integer signed
#define HALFSINT s8		// half integer signed
#define DBLFIX fix32	// double fixed point class
#define QUADFIX fix64B	// quadruple fixed point class
#include "quadint_cpp.h"

// uint128B, sint128B (only for test)
#define QUADUINT uint128B // quadruple integer class
#define DBLUINT uint64	// double integer class unsigned
#define BASEUINT u32	// base integer unsigned
#define HALFUINT u16	// half integer unsigned
#define QUADSINT sint128B // double integer class signed
#define DBLSINT sint64	// double integer class signed
#define BASESINT s32	// base integer signed
#define HALFSINT s16	// half integer signed
#define DBLFIX fix64	// double fixed point class
#define QUADFIX fix128B	// quadruple fixed point class
#include "quadint_cpp.h"

// uint256, sint256 (with assembler)
#define QUADUINT uint256 // quadruple integer class
#define DBLUINT uint128	// double integer class unsigned
#define BASEUINT u64	// base integer unsigned
#define HALFUINT u32	// half integer unsigned
#define QUADSINT sint256 // double integer class signed
#define DBLSINT sint128	// double integer class signed
#define BASESINT s64	// base integer signed
#define HALFSINT s32	// half integer signed
#define DBLFIX fix128	// double fixed point class
#define QUADFIX fix256	// quadruple fixed point class
#define USEASM			// can use assembler
#include "quadint_cpp.h"

// uint256ref, sint256ref (without assembler - only for test as reference)
#define QUADUINT uint256ref // quadruple integer class unsigned
#define DBLUINT uint128	// double integer class unsigned
#define BASEUINT u64	// base integer unsigned
#define HALFUINT u32	// half integer unsigned
#define QUADSINT sint256ref // double integer class signed
#define DBLSINT sint128	// double integer class signed
#define BASESINT s64	// base integer signed
#define HALFSINT s32	// half integer signed
#define DBLFIX fix128ref // double fixed point class
#define QUADFIX fix256ref // quadruple fixed point class
#include "quadint_cpp.h"

#pragma warning ( disable: 4146)		// warning - unsigned minus

///////////////////////////////////////////////////////////////////////////////
// print number in hex code

void PrintTestHex(LPCTSTR name, void* num, int bits)
{
	fprintf(stderr, "   %s=", name);

	int i;
	u16* s = (u16*)num;
	for (i = bits/16 - 1; i >= 0; i--)
	{
		fprintf(stderr, "%04X", s[i]);
		if (i > 0) printf(":");
	}

	fprintf(stderr, "\n");
}

///////////////////////////////////////////////////////////////////////////////
// fixed point reference number help functions

s64 RefMul64(s64 u, s64 v)
{
	sint128 z;
	z.Mul(u, v);
	z.RShift(32);
	return z.N0();
}

s64 RefDiv64(s64 u, s64 v)
{
	bool neg = false;

	if (u < 0)
	{
		u = -u;
		neg = true;
	}

	if (v < 0)
	{
		v = -v;
		neg = !neg;
	}

	sint128 z;
	z = u;
	z.LShift(32);
	if (z.N1() >= v)
	{
		if (neg)
			return (s64)(1ULL << 63);
		else
			return (s64)((1ULL << 63) - 1);
	}
	z.Div(v);
	if (neg) z.Neg();
	return z.N0();
}

s64 RefMod64(s64 u, s64 v)
{
	s64 z = u/v;
	return u - z*v;
}

///////////////////////////////////////////////////////////////////////////////
// check double integer + u64

#define TESTINT uint64	// tested number class
#define REFINT u64		// reference number class
#define REFISCLS 0		// 1=reference number is class, 0=reference number is integer
#define BASEINT u32		// base integer
#define HALFINT u16		// half integer
#define TESTBITS 64		// number of bits

void Check_dbluint(int max)
{
	LPCTSTR name = "Check_dbluint";
//#pragma message("...test_func.h: Check_dbluint")
#include "test_func.h"
}

///////////////////////////////////////////////////////////////////////////////
// check double integer + s64

#define TESTINT sint64	// tested number class
#define REFINT s64		// reference number class
#define REFISCLS 0		// 1=reference number is class, 0=reference number is integer
#define BASEINT s32		// base integer
#define HALFINT s16		// half integer
#define TESTBITS 64		// number of bits
#define SIGNED			// signed number

void Check_dblsint(int max)
{
	LPCTSTR name = "Check_dblsint";
//#pragma message("...test_func.h: Check_dblsint")
#include "test_func.h"
}

///////////////////////////////////////////////////////////////////////////////
// check double fix + double

#define TESTINT fix64	// tested number class
#define REFINT s64		// reference number class
#define REFISCLS 0		// 1=reference number is class, 0=reference number is integer
#define BASEINT s32		// base integer
#define HALFINT s16		// half integer
#define TESTBITS 64		// number of bits
#define SIGNED			// flag - signed number
#define FIXED			// flag - fix point number

void Check_dblfix(int max)
{
	LPCTSTR name = "Check_dblfix";
//#pragma message("...test_func.h: Check_dblfix")
#include "test_func.h"
}

///////////////////////////////////////////////////////////////////////////////
// check quadruple integer + u64

#define TESTINT uint64B // tested number class
#define REFINT u64		// reference number class
#define REFISCLS 0		// 1=reference number is class, 0=reference number is integer
#define BASEINT u16		// base integer
#define HALFINT u8		// half integer
#define TESTBITS 64		// number of bits

#define DBLINT1 uint32	// double integer class for tested number
#define DBLINT2 u32		// double integer for reference number

void Check_quaduint(int max)
{
	LPCTSTR name = "Check_quaduint";
//#pragma message("...test_func.h: Check_quaduint")
#include "test_func.h"
}

///////////////////////////////////////////////////////////////////////////////
// check quadruple integer + s64

#define TESTINT sint64B // tested number class
#define REFINT s64		// reference number class
#define REFISCLS 0		// 1=reference number is class, 0=reference number is integer
#define BASEINT s16		// base integer
#define HALFINT s8		// half integer
#define TESTBITS 64		// number of bits
#define SIGNED			// signed number

#define DBLINT1 sint32	// double integer class for tested number
#define DBLINT2 s32		// double integer for reference number

void Check_quadsint(int max)
{
	LPCTSTR name = "Check_quadsint";
//#pragma message("...test_func.h: Check_quadsint")
#include "test_func.h"
}

///////////////////////////////////////////////////////////////////////////////
// check quadruple fix + double

#define TESTINT fix64B	// tested number class
#define REFINT s64		// reference number class
#define REFISCLS 0		// 1=reference number is class, 0=reference number is integer
#define BASEINT s16		// base integer
#define HALFINT s8		// half integer
#define TESTBITS 64		// number of bits
#define SIGNED			// signed number
#define FIXED			// flag - fix point number

#define DBLINT1 fix32	// double integer class for tested number
#define DBLINT2 s32		// double integer for reference number

void Check_quadfix(int max)
{
	LPCTSTR name = "Check_quadfix";
//#pragma message("...test_func.h: Check_quadfix")
#include "test_func.h"
}

///////////////////////////////////////////////////////////////////////////////
// check quadruple integer + double integer unsigned

#define TESTINT uint128B // tested number class
#define REFINT uint128	// reference number class
#define REFISCLS 1		// 1=reference number is class, 0=reference number is integer
#define BASEINT u32		// base integer
#define HALFINT u16		// half integer
#define TESTBITS 128	// number of bits

void Check_quadudbl(int max)
{
	LPCTSTR name = "Check_quadudbl";
//#pragma message("...test_func.h: Check_quadudbl")
#include "test_func.h"
}

///////////////////////////////////////////////////////////////////////////////
// check quadruple integer + double integer signed

#define TESTINT sint128B // tested number class
#define REFINT sint128	// reference number class
#define REFISCLS 1		// 1=reference number is class, 0=reference number is integer
#define BASEINT s32		// base integer
#define HALFINT s16		// half integer
#define TESTBITS 128	// number of bits
#define SIGNED			// signed number

void Check_quadsdbl(int max)
{
	LPCTSTR name = "Check_quadsdbl";
//#pragma message("...test_func.h: Check_quadsdbl")
#include "test_func.h"
}

#ifdef WIN64

///////////////////////////////////////////////////////////////////////////////
// check double integer assembler unsigned (compile with x64!)

#define TESTINT uint128 // tested number class
#define REFINT uint128ref // reference number class
#define REFISCLS 1		// 1=reference number is class, 0=reference number is integer
#define BASEINT u64		// base integer
#define HALFINT u32		// half integer
#define TESTBITS 128	// number of bits

void Check_dbluint_asm(int max)
{
	LPCTSTR name = "Check_dbluint_asm";
//#pragma message("...test_func.h: Check_dbluint_asm")
#include "test_func.h"
}

///////////////////////////////////////////////////////////////////////////////
// check double integer assembler signed (compile with x64!)

#define TESTINT sint128 // tested number class
#define REFINT sint128ref // reference number class
#define REFISCLS 1		// 1=reference number is class, 0=reference number is integer
#define BASEINT s64		// base integer
#define HALFINT s32		// half integer
#define TESTBITS 128	// number of bits
#define SIGNED			// signed number

void Check_dblsint_asm(int max)
{
	LPCTSTR name = "Check_dblsint_asm";
//#pragma message("...test_func.h: Check_dblsint_asm")
#include "test_func.h"
}

///////////////////////////////////////////////////////////////////////////////
// check quadruple integer assembler unsigned (compile with x64!)

#define TESTINT uint256 // tested number class
#define REFINT uint256ref // reference number class
#define REFISCLS 1		// 1=reference number is class, 0=reference number is integer
#define BASEINT u64		// base integer
#define HALFINT u32		// half integer
#define TESTBITS 256	// number of bits

#define DBLINT1 uint128 // double integer class for tested number
#define DBLINT2 uint128 // double integer for reference number

void Check_quaduint_asm(int max)
{
	LPCTSTR name = "Check_quaduint_asm";
//#pragma message("...test_func.h: Check_quaduint_asm")
#include "test_func.h"
}

///////////////////////////////////////////////////////////////////////////////
// check quadruple integer assembler signed (compile with x64!)

#define TESTINT sint256 // tested number class
#define REFINT sint256ref // reference number class
#define REFISCLS 1		// 1=reference number is class, 0=reference number is integer
#define BASEINT s64		// base integer
#define HALFINT s32		// half integer
#define TESTBITS 256	// number of bits
#define SIGNED			// signed number

#define DBLINT1 sint128 // double integer class for tested number
#define DBLINT2 sint128 // double integer for reference number

void Check_quadsint_asm(int max)
{
	LPCTSTR name = "Check_quadsint_asm";
//#pragma message("...test_func.h: Check_quadsint_asm")
#include "test_func.h"
}

#endif // WIN64

///////////////////////////////////////////////////////////////////////////////
// test dblint timming

#define K1 1000000	// number of loops - fast functions
#define K2 (K1/5)	// number of loops - middle functions
#define K3 (K2/4)	// number of loops - slow functions

#pragma optimize( "", off ) // switch off optimisation, or C++ functions will be removed

void TestDblIntTime()
{
	int i;
	int loop = 0;
	double t1 = 0;
	double t2 = 0;
	double t3 = 0;
	double t4 = 0;
	int k;

	printf("TestDblInTime (uint128-ASM / uint128ref-C, sint128-ASM / sint128ref-C):\n");

	k = K1;
#define KKK c.Add(a)
#define TTT "this += num"
#include "test_dbltime.h"

#define KKK c.Add(a2)
#define TTT "this += 0:num"
#include "test_dbltime.h"

#define KKK c.Add(a,b)
#define TTT "this = num1 + num2"
#include "test_dbltime.h"

#define KKK c.Add(a,b2)
#define TTT "this = num1 + 0:num2"
#include "test_dbltime.h"


#define KKK c.Sub(a)
#define TTT "this -= num"
#include "test_dbltime.h"

#define KKK c.Sub(a2)
#define TTT "this -= 0:num"
#include "test_dbltime.h"

#define KKK c.Sub(a,b)
#define TTT "this = num1 - num2"
#include "test_dbltime.h"

#define KKK c.Sub(a,b2)
#define TTT "this = num1 - 0:num2"
#include "test_dbltime.h"

#define KKK c.Sub(a2,b)
#define TTT "this = 0:num1 - num2"
#include "test_dbltime.h"

#define KKK c.InvSub(a)
#define TTT "this = num - this"
#include "test_dbltime.h"

#define KKK c.InvSub(a2)
#define TTT "this = 0:num - this"
#include "test_dbltime.h"


#define KKK c.Inc()
#define TTT "this++"
#include "test_dbltime.h"

#define KKK c.Inc(a)
#define TTT "this = num + 1"
#include "test_dbltime.h"

#define KKK c.Dec()
#define TTT "this--"
#include "test_dbltime.h"

#define KKK c.Dec(a)
#define TTT "this = num - 1"
#include "test_dbltime.h"


	k = K2;
#define KKK c.Mul(a,b)
#define TTT "this = num1 * num2"
#include "test_dbltime.h"

#define KKK c.Mul(a,b2)
#define TTT "this = num1 * 0:num2"
#include "test_dbltime.h"

#define KKK c.Mul(a2,b2)
#define TTT "this = 0:num1 * 0:num2"
#include "test_dbltime.h"

#define KKK c.Mul10(a)
#define TTT "this = num * 10"
#include "test_dbltime.h"


#define KKK c.Sqr(a)
#define TTT "this = num * num"
#include "test_dbltime.h"

#define KKK c.Sqr(a2)
#define TTT "this = 0:num * 0:num"
#include "test_dbltime.h"


	k = K3;
#define KKK c.Div(a,b)
#define TTT "this = num1 / num2"
#include "test_dbltime.h"

#define KKK c.Div(a,b0)
#define TTT "this = num1 / (0:)num2"
#include "test_dbltime.h"

#define KKK c.Div(a,b2)
#define TTT "this = num1 / 0:num2"
#include "test_dbltime.h"

#define KKK c.Div(a,a3)
#define TTT "this = num1 / 0:0:0:num2"
#include "test_dbltime.h"

#define KKK c.Div10(a)
#define TTT "this = num / 10"
#include "test_dbltime.h"

#define KKK c.DivHigh(ub, b, a)
#define TTT "this = num1H:num1L / num2"
#include "test_dbltime.h"

#define KKK shift=c.PreFastDiv(b)
#define TTT "PreFastDiv"
#include "test_dbltime.h"

	k = K2;
#define KKK c.FastDiv(a, c_1, shift_1)
#define TTT "FASTDIV_1"
#include "test_dbltime.h"

#define KKK c.FastDiv(a, c_2, shift_2)
#define TTT "FASTDIV_2"
#include "test_dbltime.h"

#define KKK c.FastDiv(a, c_3, shift_3)
#define TTT "FASTDIV_SHIFT"
#include "test_dbltime.h"

#define KKK c.FastDiv(a, c_4, shift_4)
#define TTT "FASTDIV_HIGH"
#include "test_dbltime.h"

#define KKK c.FastDiv(a, c_5, shift_5)
#define TTT "FASTDIV_MUL"
#include "test_dbltime.h"

#define KKK c.FastDiv(a, c_6, shift_6)
#define TTT "FASTDIV_FULL"
#include "test_dbltime.h"

	k = K1;
#define KKK c.SetBit(3)
#define TTT "set bit"
#include "test_dbltime.h"

#define KKK c.ResBit(80)
#define TTT "reset bit"
#include "test_dbltime.h"

#define KKK c.GetBit(31)
#define TTT "get bit"
#include "test_dbltime.h"

#define KKK c.Bits()
#define TTT "bits"
#include "test_dbltime.h"

	printf("// (total) %.1f ns / %.1f ns, %.1f ns / %.1f ns\n", t1, t2, t3, t4);

	fprintf(stderr, "\r                                    \r");
}

#pragma optimize( "", on )

///////////////////////////////////////////////////////////////////////////////
// test quadint timming

#pragma optimize( "", off ) // switch off optimisation, or C++ functions will be removed

void TestQuadIntTime()
{
	int i;
	int loop = 0;
	double t1 = 0;
	double t2 = 0;
	double t3 = 0;
	double t4 = 0;
	int k;

	printf("TestQuadInTime (uint256-ASM / uint256ref-C, sint256-ASM / sint256ref-C):\n");

	k = K1;
#define KKK c.Add(a)
#define TTT "this += num"
#include "test_quadtime.h"

#define KKK c.Add(a4)
#define TTT "this += 0:num"
#include "test_quadtime.h"

#define KKK c.Add(a2)
#define TTT "this += 0:0:0:num"
#include "test_quadtime.h"

#define KKK c.Add(a,b)
#define TTT "this = num1 + num2"
#include "test_quadtime.h"

#define KKK c.Add(a,b4)
#define TTT "this = num1 + 0:num2"
#include "test_quadtime.h"

#define KKK c.Add(a,b2)
#define TTT "this = num1 + 0:0:0:num2"
#include "test_quadtime.h"


#define KKK c.Sub(a)
#define TTT "this -= num"
#include "test_quadtime.h"

#define KKK c.Sub(a4)
#define TTT "this -= 0:num"
#include "test_quadtime.h"

#define KKK c.Sub(a2)
#define TTT "this -= 0:0:0:num"
#include "test_quadtime.h"

#define KKK c.Sub(a,b)
#define TTT "this = num1 - num2"
#include "test_quadtime.h"

#define KKK c.Sub(a,b4)
#define TTT "this = num1 - 0:num2"
#include "test_quadtime.h"

#define KKK c.Sub(a4,b)
#define TTT "this = 0:num1 - num2"
#include "test_quadtime.h"

#define KKK c.Sub(a,b2)
#define TTT "this = num1 - 0:0:0:num2"
#include "test_quadtime.h"

#define KKK c.Sub(a2,b)
#define TTT "this = 0:0:0:num1 - num2"
#include "test_quadtime.h"

#define KKK c.InvSub(a)
#define TTT "this = num - this"
#include "test_quadtime.h"

#define KKK c.InvSub(a4)
#define TTT "this = 0:num - this"
#include "test_quadtime.h"

#define KKK c.InvSub(a2)
#define TTT "this = 0:0:0:num - this"
#include "test_quadtime.h"


#define KKK c.Inc()
#define TTT "this++"
#include "test_quadtime.h"

#define KKK c.Inc(a)
#define TTT "this = num + 1"
#include "test_quadtime.h"

#define KKK c.Dec()
#define TTT "this--"
#include "test_quadtime.h"

#define KKK c.Dec(a)
#define TTT "this = num - 1"
#include "test_quadtime.h"


	k = K2;
#define KKK c.Mul(a,b)
#define TTT "this = num1 * num2"
#include "test_quadtime.h"

#define KKK c.Mul(a,b0)
#define TTT "this = num1 * (0:)num2"
#include "test_quadtime.h"

#define KKK c.Mul(a0,b)
#define TTT "this = (0:)num1 * num2"
#include "test_quadtime.h"

#define KKK c.Mul(a,b02)
#define TTT "this = num1 * (0:0:0:)num2"
#include "test_quadtime.h"

#define KKK c.Mul(a02,b)
#define TTT "this = (0:0:0:)num1 * num2"
#include "test_quadtime.h"

#define KKK c.Mul(a,b4)
#define TTT "this = num1 * 0:num2"
#include "test_quadtime.h"

#define KKK c.Mul(a4,b)
#define TTT "this = 0:num1 * num2"
#include "test_quadtime.h"

#define KKK c.Mul(a,b2)
#define TTT "this = num1 * 0:0:0:num2"
#include "test_quadtime.h"

#define KKK c.Mul(a2,b)
#define TTT "this = 0:0:0:num1 * num2"
#include "test_quadtime.h"

#define KKK c.Mul(a4,b4)
#define TTT "this = 0:num1 * 0:num2"
#include "test_quadtime.h"

#define KKK c.Mul(a4,b2)
#define TTT "this = 0:num1 * 0:0:0:num2"
#include "test_quadtime.h"

#define KKK c.Mul(a2,b4)
#define TTT "this = 0:0:0:num1 * 0:num2"
#include "test_quadtime.h"

#define KKK c.Mul(a2,b2)
#define TTT "this = 0:0:0:num1 * 0:0:0:num2"
#include "test_quadtime.h"

#define KKK c.Mul10(a)
#define TTT "this = num * 10"
#include "test_quadtime.h"


#define KKK c.Sqr(a)
#define TTT "this = num * num"
#include "test_quadtime.h"

#define KKK c.Sqr(a4)
#define TTT "this = 0:num * 0:num"
#include "test_quadtime.h"

#define KKK c.Sqr(a2)
#define TTT "this = 0:0:0:num * 0:0:0:num"
#include "test_quadtime.h"

	k = K3;
#define KKK c.Div(a,b)
#define TTT "this = num1 / num2"
#include "test_quadtime.h"

#define KKK c.Div(a,b0)
#define TTT "this = num1 / (0:)num2"
#include "test_quadtime.h"

#define KKK c.Div(a,b02)
#define TTT "this = num1 / (0:0:0:)num2"
#include "test_quadtime.h"

#define KKK c.Div(a,b4)
#define TTT "this = num1 / 0:num2"
#include "test_quadtime.h"

#define KKK c.Div(a,b2)
#define TTT "this = num1 / 0:0:0:num2"
#include "test_quadtime.h"

#define KKK c.Div(a,a3)
#define TTT "this = num1 / 0:0:0:0:0:0:0:num2"
#include "test_quadtime.h"

#define KKK c.Div10(a)
#define TTT "this = num / 10"
#include "test_quadtime.h"

#define KKK c.DivHigh(ub, b, a)
#define TTT "this = num1H:num1L / num2"
#include "test_quadtime.h"

#define KKK shift=c.PreFastDiv(b)
#define TTT "PreFastDiv"
#include "test_quadtime.h"

	k = K2;
#define KKK c.FastDiv(a, c_1, shift_1)
#define TTT "FASTDIV_1"
#include "test_quadtime.h"

#define KKK c.FastDiv(a, c_2, shift_2)
#define TTT "FASTDIV_2"
#include "test_quadtime.h"

#define KKK c.FastDiv(a, c_3, shift_3)
#define TTT "FASTDIV_SHIFT"
#include "test_quadtime.h"

#define KKK c.FastDiv(a, c_4, shift_4)
#define TTT "FASTDIV_HIGH"
#include "test_quadtime.h"

#define KKK c.FastDiv(a, c_5, shift_5)
#define TTT "FASTDIV_MUL"
#include "test_quadtime.h"

#define KKK c.FastDiv(a, c_6, shift_6)
#define TTT "FASTDIV_FULL"
#include "test_quadtime.h"

	k = K1;
#define KKK c.SetBit(3)
#define TTT "set bit"
#include "test_quadtime.h"

#define KKK c.ResBit(80)
#define TTT "reset bit"
#include "test_quadtime.h"

#define KKK c.GetBit(31)
#define TTT "get bit"
#include "test_quadtime.h"

#define KKK c.Bits()
#define TTT "bits"
#include "test_quadtime.h"


	printf("// (total) %.1f ns / %.1f ns, %.1f ns / %.1f ns\n", t1, t2, t3, t4);

	fprintf(stderr, "\r                                    \r");
}

#undef K0

#pragma optimize( "", on )
